\version "2.24.0"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  system-system-spacing = #'((basic-distance . 15))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  %ragged-right = ##t
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Sub milostivirea ta"
  %subtitle = "Ps. 121"
  %subsubtitle = "Op. 21"
  %poet = "Vasile Militaru (1885 - 1959)"
  composer = \markup \center-column { "arm. de N. Moldoveanu" }
  %arranger = "io"
  meter = "Andante"
  tagline=""
}

global = {
  \key a \major
  \autoBeamOff
  %\cadenzaOn
  %\time 6/8
  %\partial 8.
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Sub mi -- lo -- sti -- vi -- rea ta 
  scă -- păm, scă -- păm, 
  Năs -- că -- toa -- re de Dum -- ne -- zeu
  Fe -- cioa -- ră.
  Ru -- gă -- ciu -- ni -- le noas -- tre
  nu le tre -- ce cu ve -- de -- rea în ne -- caz
  și ne iz -- bă -- veș -- te din ne -- voi,
  u -- na cu -- ra -- tă și
  bi -- ne -- cu -- vân -- ta -- tă.
  Prea Sfân -- tă Năs -- că -- toa -- re de Dum -- ne -- zeu,
  mi -- lu -- ieș -- te -- ne pe noi.
  Toți sfin -- ții ru -- ga -- ți -- vă lui Dum -- ne -- zeu
  pen -- tru noi. 
}

menWords = \lyricmode {
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1
  
}
  
sopMusic = \relative c'' {
  \compoundMeter #'((4 4) (3 4) (2 4))
  \cadenzaOn
  a4 gis a b  \bar"|"
  b a8[ b] cis4 cis \bar"|"
  b a \bar"|"
  gis a b \bar"|"
  b( cis) cis2
  cis4( d8[ cis]) b4 cis8[ b] \bar"|"
  a4 a \bar"|"
  gis8[ a b gis] a2 \bar"|"
  a4 gis \bar"|"
  a a b \bar"|"
  b( cis) cis2 \bar"|"
  cis4 d8[ cis] b4 cis8[ b] \bar"|"
  a4 a \bar"|"
  gis8[ a b gis] a2 \bar"|"
  a4 b \bar"|"  
  cis2 cis4 d8[ cis] \bar"|"
  b4 cis8[ b] \bar"|"
  a4 gis \bar"|"
  a b cis2 \bar"|"
  cis4 b cis \bar"|"
  d4( e) d cis8[ b] \bar"|"
  a8[ b] cis4 b a \bar"|"
  gis8[ a b gis] a2 \bar"|"
  a4 a8 a a b \bar"|"
  cis2 b4 b \bar"|"
  a gis \bar"|"
  a2 a4 b \bar"|"
  cis2. b4 \bar"|"
  a2 gis \bar"|"
  a4 \breathe b \bar"|"
  cis2 b4. b8 \bar"|"
  cis4. b8 a gis a b \bar"|"
  cis4( b) \bar"|"
  a2 gis \bar"|"
  a2. \fermata 
  \bar "|." 
  
}

altMusic = \relative c'' {
  a4 gis fis gis \bar"|"
  gis fis8[ gis] a4 a \bar"|"
  gis fis \bar"|"
  eis fis gis \bar"|"
  gis( a) a2 \bar"|"
  a4( b8[ a]) gis4 a8[ gis] \bar"|"
  fis4 fis \bar"|"
  eis8[ fis gis eis] fis2 \bar"|"
  a4 gis \bar"|"
  fis fis gis \bar"|"
  gis( a) a2 \bar"|"
  a4 b8[ a] gis4 a8[ gis] \bar"|"
  fis4 fis \bar"|"
  eis8[ fis gis eis] fis2 \bar"|"
  fis4 gis \bar"|"
  a2 a4 b8[ a] \bar"|"
  gis4 a8[ gis] \bar"|"
  fis4 eis \bar"|"
  fis gis a2 \bar"|"
  a4 gis a \bar"|"
  b4( cis) b a8[ gis] \bar"|"
  fis8[ gis] a4 gis fis \bar"|"
  eis8[ fis gis eis] fis2 \bar"|"
  fis4 fis8 fis fis gis \bar"|"
  a2 gis4 gis \bar"|"
  fis eis \bar"|"
  fis2 fis4 gis \bar"|"
  a2. gis4 \bar"|"
  fis2 eis \bar"|"
  fis4 gis \bar"|"
  a2 gis4. gis8 \bar"|"
  a4. gis8 fis eis fis gis \bar"|"
  a4( gis) \bar"|"
  fis2 gis \bar"|"
  a2.  
}  

tenorMusic = \relative c' {
  \compoundMeter #'((4 4) (3 4) (2 4))
  a4 gis fis e \bar"|"
  e d8[ e] a4 e \bar"|"
  e4 fis \bar"|"
  cis fis e \bar"|"
  e( a) a2 \bar"|"
  a4( b8[ a]) e4 e \bar"|"
  fis fis \bar"|"
  cis2 fis \bar"|"
  a4 gis \bar"|"
  fis fis e \bar"|"
  e( a) a2 \bar"|"
  a4 b8[ a] e4 e \bar"|"
  fis fis \bar"|"
  cis2 fis \bar"|"
  fis4 e \bar"|"
  e2 e4 e \bar"|"
  e e \bar"|"
  fis cis \bar"|"
  fis e a2 \bar"|"
  a4 e a \bar"|"
  gis( a) e4 e \bar"|"
  e e e fis \bar"|"
  cis2 fis \bar"|"
  fis4 fis8 fis fis e \bar"|"
  e2 e4 e \bar"|"
  fis cis \bar"|"
  fis2 fis4 e \bar"|"
  a2. e4 \bar"|"
  fis2 cis \bar"|"
  fis4 \breathe e \bar"|"
  e2 e4. e8 \bar"|"
  a4. gis8 fis cis fis e \bar"|"
  a4( gis) \bar"|"
  fis2 e \bar"|"
  a2. \fermata  
}

bassMusic = \relative c' {
  a4 gis fis e \bar"|"
  e d8[ e] a4 a,8[ cis] \bar"|"
  e4 fis \bar"|"
  cis fis e \bar"|"
  e( a) a2 \bar"|"
  a4( b8[ a]) e4 e \bar"|"
  fis fis \bar"|"
  cis2 fis \bar"|"
  a4 gis \bar"|"
  fis fis e \bar"|"
  e( a) a2 \bar"|"
  a4 b8[ a] e4 e \bar"|"
  fis fis \bar"|"
  cis2 fis \bar"|"
  fis4 e \bar"|"
  a,2 a8[ cis] e4 \bar"|"
  e e \bar"|"
  fis cis \bar"|"
  fis e a2 \bar"|"
  a4 e e \bar"|"
  e2 e4 e \bar"|"
  e e e fis \bar"|"
  cis2 fis \bar"|"
  fis4 fis8 fis fis e \bar"|"
  a,4( cis) e4 e \bar"|"
  fis cis \bar"|"
  fis2 fis4 e \bar"|"
  a2. e4 \bar"|"
  fis2 cis \bar"|"
  fis4 \breathe e \bar"|"
  e2 e4. e8 \bar"|"
  a4. gis8 fis cis fis e \bar"|"
  a4( gis) \bar"|"
  fis2 e \bar"|"
  a,2. \bar"|." 
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 50
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}